/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.atmSW;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class PVCEpCreateWizard
implements JDMWizardPanelDelegate {
    protected static ResourceBundle bundle = ResourceBundle.getBundle("ibm.nways.atmSW.Resources");
    protected JdmBrowser browser;
    protected boolean isVersion3OrGreaterAgent = true;

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
        Serializable serializable;
        String string = "setDefaults";
        DestinationPropBook destinationPropBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        this.browser = (JdmBrowser)destinationPropBook.getBrowser();
        GenModel genModel = jDMWizardInfo.getModel();
        Serializable serializable2 = null;
        try {
            serializable = genModel.getInfo("AgentInfo");
            this.isVersion3OrGreaterAgent = this.checkAgentVersion((ModelInfo)serializable);
            serializable2 = ((ModelInfo)serializable).get("AgentInfo.PnniNodeAtmAddress");
        }
        catch (Exception exception) {
            RAS.logException(19, 2, this, string, exception);
        }
        serializable = jDMWizardInfo.getItems();
        ((Hashtable)serializable).put("atmPvcEpIndex", new Integer(101));
        ((Hashtable)serializable).put("atmPvcEpIdentifier", new Integer(1));
        ((Hashtable)serializable).put("atmPvcEpParty", new Integer(1));
        if (serializable2 != null && serializable2 instanceof OctetString) {
            ((Hashtable)serializable).put("atmPvcEpRemAddress", new OctetString(serializable2.toString().substring(0, 26)));
            ((Hashtable)serializable).put("atmPvcEpAtmAddress", serializable2);
        } else {
            ((Hashtable)serializable).put("atmPvcEpRemAddress", new OctetString("00000000000000000000000000"));
            ((Hashtable)serializable).put("atmPvcEpAtmAddress", new OctetString("0000000000000000000000000000000000000000"));
        }
        ((Hashtable)serializable).put("atmPvcEpMode", new Integer(2));
        ((Hashtable)serializable).put("atmPvcEpRemIndex", new Integer(101));
        ((Hashtable)serializable).put("atmPvcEpRemVpi", new Integer(65536));
        ((Hashtable)serializable).put("atmPvcEpRemVci", new Integer(65536));
        this.displayMsg("PVCEp_createConfirm");
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        this.displayMsg("PVCEp_createAbort");
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        String string;
        boolean bl;
        block16: {
            String string2 = "proceed";
            bl = true;
            GenModel genModel = jDMWizardInfo.getModel();
            Hashtable hashtable = jDMWizardInfo.getItems();
            ModelInfo modelInfo = new ModelInfo();
            string = "PVCEp_createError";
            this.displayMsg("PVCEp_creating");
            modelInfo.add("Index.AtmPvcEpIndex", (Integer)hashtable.get("atmPvcEpIndex"));
            modelInfo.add("Index.AtmPvcEpIdentifier", (Integer)hashtable.get("atmPvcEpIdentifier"));
            modelInfo.add("Index.AtmPvcEpParty", (Integer)hashtable.get("atmPvcEpParty"));
            modelInfo.add("Panel.AtmPvcEpRowStatus", new Integer(5));
            try {
                modelInfo = genModel.setInfo("Panel", modelInfo);
                bl = this.checkSetInfo(modelInfo);
                if (!bl) break block16;
                modelInfo.removeAll();
                modelInfo.add("Index.AtmPvcEpIndex", (Integer)hashtable.get("atmPvcEpIndex"));
                modelInfo.add("Index.AtmPvcEpIdentifier", (Integer)hashtable.get("atmPvcEpIdentifier"));
                modelInfo.add("Index.AtmPvcEpParty", (Integer)hashtable.get("atmPvcEpParty"));
                int n = (Integer)hashtable.get("atmPvcEpMode");
                int n2 = (Integer)hashtable.get("atmPvcEpRemIndex");
                String string3 = ((OctetString)hashtable.get("atmPvcEpAtmAddress")).toString();
                String string4 = ((OctetString)hashtable.get("atmPvcEpRemAddress")).toString();
                if (!this.isVersion3OrGreaterAgent && n == 1) {
                    string4 = string3.substring(0, 26);
                    try {
                        n2 = Integer.parseInt(string3.substring(36, 38), 16) * 100 + Integer.parseInt(string3.substring(38, 40), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        RAS.logException(19, 2, this, string2, (Exception)numberFormatException);
                    }
                    if (RAS.isEnabled(19, 2)) {
                        RAS.trace(19, 2, this, string2, "Prefix is : " + string4 + " Interface : " + n2);
                    }
                }
                if (this.isVersion3OrGreaterAgent && n == 2) {
                    string3 = String.valueOf(string4) + "42000000";
                    String string5 = Integer.toHexString(n2 / 100);
                    String string6 = Integer.toHexString(n2 % 100);
                    if (string5.length() == 1) {
                        string5 = "0" + string5;
                    }
                    if (string6.length() == 1) {
                        string6 = "0" + string6;
                    }
                    string3 = String.valueOf(string3) + string5 + string6 + "00";
                    if (RAS.isEnabled(19, 2)) {
                        RAS.trace(19, 2, this, string2, "ATM Address to be set is : " + string3);
                    }
                }
                if (this.isVersion3OrGreaterAgent) {
                    modelInfo.add("Panel.AtmPvcEpAtmAddress", new OctetString(string3));
                } else {
                    modelInfo.add("Panel.AtmPvcEpAtmAddress", new OctetString(string4));
                    modelInfo.add("Panel.AtmPvcEpRemIndex", new Integer(n2));
                }
                modelInfo.add("Panel.AtmPvcEpRemVpi", (Integer)hashtable.get("atmPvcEpRemVpi"));
                modelInfo.add("Panel.AtmPvcEpRemVci", (Integer)hashtable.get("atmPvcEpRemVci"));
                modelInfo = genModel.setInfo("Panel", modelInfo);
                bl = this.checkSetInfo(modelInfo);
                if (bl) {
                    this.displayMsg("PVCEp_activating");
                    modelInfo.removeAll();
                    modelInfo.add("Index.AtmPvcEpIndex", (Integer)hashtable.get("atmPvcEpIndex"));
                    modelInfo.add("Index.AtmPvcEpIdentifier", (Integer)hashtable.get("atmPvcEpIdentifier"));
                    modelInfo.add("Index.AtmPvcEpParty", (Integer)hashtable.get("atmPvcEpParty"));
                    modelInfo.add("Panel.AtmPvcEpRowStatus", new Integer(1));
                    modelInfo = genModel.setInfo("Panel", modelInfo);
                    bl = this.checkSetInfo(modelInfo);
                    if (!bl) {
                        string = "PVCEp_createErrorActivate";
                    }
                }
            }
            catch (Exception exception) {
                RAS.logException(19, 2, this, string2, exception);
                bl = false;
            }
        }
        if (!bl) {
            this.displayMsg(string);
        } else {
            this.displayMsg("PVCEp_createOK");
        }
        return bl;
    }

    private boolean checkSetInfo(ModelInfo modelInfo) {
        String string = "checkSetInfo";
        Enumeration enumeration = modelInfo.getItemIds();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Serializable serializable = modelInfo.get(string2);
            if (!(serializable instanceof SpecialValue)) continue;
            if (RAS.isEnabled(19, 2)) {
                RAS.trace(19, 2, this, string, "Got a special value for ID -> " + string2);
            }
            System.out.println("Got a special value for ID -> " + string2);
            return false;
        }
        return true;
    }

    protected boolean checkAgentVersion(ModelInfo modelInfo) {
        Serializable serializable = modelInfo.get("AgentInfo.ModuleType1");
        if (serializable instanceof Integer && (Integer)serializable == 6) {
            serializable = modelInfo.get("AgentInfo.ModuleSoftwareVersion1");
            if (serializable instanceof String) {
                String string = (String)((Object)serializable);
                char c = string.charAt(2);
                return c >= '0' && c <= '9' && c >= '3';
            }
            return false;
        }
        serializable = modelInfo.get("AgentInfo.ModuleType9");
        if (serializable instanceof Integer && (Integer)serializable == 2 && (serializable = modelInfo.get("AgentInfo.ModuleOperState9")) instanceof Integer && (Integer)serializable == 2) {
            serializable = modelInfo.get("AgentInfo.ModuleSoftwareVersion9");
            if (serializable instanceof String) {
                String string = (String)((Object)serializable);
                char c = string.charAt(2);
                return c >= '0' && c <= '9' && c >= '3';
            }
            return false;
        }
        serializable = modelInfo.get("AgentInfo.ModuleType11");
        if (serializable instanceof Integer && (Integer)serializable == 2 && (serializable = modelInfo.get("AgentInfo.ModuleOperState11")) instanceof Integer && (Integer)serializable == 2) {
            serializable = modelInfo.get("AgentInfo.ModuleSoftwareVersion11");
            if (serializable instanceof String) {
                String string = (String)((Object)serializable);
                char c = string.charAt(2);
                return c >= '0' && c <= '9' && c >= '3';
            }
            return false;
        }
        return false;
    }

    protected void displayMsg(String string) {
        if (this.browser != null) {
            this.browser.displayMsg(PVCEpCreateWizard.getNLSString(string));
        }
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = bundle.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }
}

